//package globalExamples;

import oracle.olapi.data.cursor.CompoundCursor;
import oracle.olapi.data.cursor.Cursor;
import oracle.olapi.data.cursor.CursorManager;
import oracle.olapi.data.cursor.ValueCursor;

import oracle.olapi.data.source.CursorManagerSpecification;
import oracle.olapi.data.source.CompoundCursorSpecification;
import oracle.olapi.data.source.CursorSpecification;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.NumberSource;
import oracle.olapi.data.source.SpecifiedCursorManager;
import oracle.olapi.data.source.StringSource;

import oracle.olapi.transaction.TransactionProvider;
import oracle.olapi.transaction.NotCommittableException;

import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;

import java.util.Iterator;
import java.util.List;

/**
 * Complete code for the examples in Chapter 9, Understanding Cursor Classes 
 * and Concepts, in the Oracle OLAP Developer's Guide to the  OLAP API.
 * 
 * This program uses the Context10g class, which uses the
 * CursorPrintWriter class.
 * 
 * @author Oracle Corporation
 */
public class CursorConceptsExamples 
{

private Context10g context = null;
private TransactionProvider tp = null;
private DataProvider dp = null;

    
  public CursorConceptsExamples()
  {
  }

  public void run(String [] args)
  {
    context = new Context10g(args, false);
    tp = context.getTransactionProvider();
    dp = context.getDataProvider();

    MdmMeasure mdmUnitPrice = context.getMdmMeasureByName("UNIT_PRICE");
    Source unitPrice = mdmUnitPrice.getSource();
    
    MdmPrimaryDimension mdmProdDim = 
                             context.getMdmPrimaryDimensionByName("PRODUCT");
    MdmPrimaryDimension mdmTimeDim = 
                             context.getMdmPrimaryDimensionByName("TIME");
    MdmLevelHierarchy mdmProdHier = (MdmLevelHierarchy) 
                                     mdmProdDim.getDefaultHierarchy();
    MdmLevelHierarchy mdmTimeHier = (MdmLevelHierarchy) 
                                     mdmTimeDim.getDefaultHierarchy();
    
    // Get the Source for the hierarchy.
    StringSource prodHier = (StringSource) mdmProdHier.getSource();
    StringSource timeHier = (StringSource) mdmTimeHier.getSource();

    Source prodSel = prodHier.selectValues(new String[] {
                                          "PRODUCT_ROLLUP::ITEM::13",
                                          "PRODUCT_ROLLUP::ITEM::14",
                                          "PRODUCT_ROLLUP::ITEM::15"});

    Source timeSel = timeHier.selectValues(new String[] {
                                          "CALENDAR::MONTH::55",
                                          "CALENDAR::MONTH::58",
                                          "CALENDAR::MONTH::61",
                                          "CALENDAR::MONTH::64"});

    // Example 9-1
    Source querySource = creatingQuerySourceExample(unitPrice, 
                                                    timeSel, 
                                                    prodSel);

    // Informal example in the "Positions of a ValueCursor" section.
    productSelVal(prodSel);                                                

    // Create a Cursor for querySource.
    Cursor queryCursor = creatingACursor(querySource);
    
    // Example 9-2
   settingTheCCPosAndGettingTheCurrentVals(queryCursor);

    // Example 9-3
    positionsInAnAsymmetricQuery(prodSel, timeSel);
    
  }

  public Source creatingQuerySourceExample(Source unitPrice,
                                           Source prodSel, 
                                           Source timeSel)
  {
    context.println("Example 9-1, Creating the querySource Query");
    
    // See the run method for the code that produces the prodSel
    // and timeSel selections.
    
    Source querySource = unitPrice.join(prodSel).join(timeSel);

    context.commit();
    context.displayResult(querySource);

    return(querySource);

  }

  // Informal example in the "Positions of a ValueCursor" section.
  public void productSelVal(Source prodSel)
  {
    context.println("\nInformal example, Getting the positions of a ValueCursor.");

    try
    {
      tp.prepareCurrentTransaction();
    }
    catch(NotCommittableException e){
      System.out.println("Caught exception " + e + ".");
    }
    tp.commitCurrentTransaction();
    CursorManagerSpecification cursorMngrSpec =
                     dp.createCursorManagerSpecification(prodSel);
    SpecifiedCursorManager cursorMngr = 
                               dp.createCursorManager(cursorMngrSpec);
    ValueCursor prodSelValCursor = (ValueCursor) cursorMngr.createCursor();
    
    // prodSelValCursor is the ValueCursor for prodSel
    context.println("ValueCursor Position  Value ");
    context.println("--------------------  ------------------------ ");
    do 
    {
      context.println("          " + prodSelValCursor.getPosition() + 
                      "           " + prodSelValCursor.getCurrentValue());
    }
    while(prodSelValCursor.next());

    prodSelValCursor.setPosition(2);
    context.println("The current position is " + prodSelValCursor.getPosition());
    context.println(prodSelValCursor.getCurrentString());
    
    cursorMngr.close();
  }
  
  public Cursor creatingACursor(Source querySource)
  {
     try
    {
      tp.prepareCurrentTransaction();
    }
    catch(NotCommittableException e){
      System.out.println("Caught exception " + e + ".");
    }
    tp.commitCurrentTransaction();
    CursorManagerSpecification cursorMngrSpec =
                     dp.createCursorManagerSpecification(querySource);
    SpecifiedCursorManager cursorMngr = 
                               dp.createCursorManager(cursorMngrSpec);
    Cursor queryCursor = cursorMngr.createCursor();

    // ... Use the Cursor in some way, such as to display its values.
    context.displayCursor(queryCursor);

    return queryCursor;
    //cursorMngr.close();
  }

  private void settingTheCCPosAndGettingTheCurrentVals(Cursor queryCursor) 
  {
    context.println("Example 9-2, Setting the CompoundCursor Position  " +
                    "and Getting the Current Values");

    CompoundCursor rootCursor = (CompoundCursor) queryCursor;
    ValueCursor baseValueCursor = rootCursor.getValueCursor();
    List outputs = rootCursor.getOutputs();
    ValueCursor output1 = (ValueCursor) outputs.get(0);
    ValueCursor output2 = (ValueCursor) outputs.get(1);
    int pos = 5;
    rootCursor.setPosition(pos);
    System.out.println("CompoundCursor position set to " + pos + ".");
    System.out.println("The current position of the CompoundCursor is = "
                      + rootCursor.getPosition() + ".");
    System.out.println("Output 1 position = " + output1.getPosition() +
                       ", value = " + output1.getCurrentValue());
    System.out.println("Output 2 position = " + output2.getPosition() +
                       ", value = " + output2.getCurrentValue());
    System.out.println("VC position = " + baseValueCursor.getPosition() +
                       ", value = " + baseValueCursor.getCurrentValue());    
  }

  private void positionsInAnAsymmetricQuery(Source prodSel, Source timeSel) 
  {
    context.println("Example 9-3, Positions in an Asymmetric Query");

    MdmMeasure mdmUnits = context.getMdmMeasureByName("UNITS");
    NumberSource units = (NumberSource) mdmUnits.getSource();
    Source unitsGT1 = units.gt(1);

    MdmPrimaryDimension mdmChanDim = 
                             context.getMdmPrimaryDimensionByName("CHANNEL");
    MdmPrimaryDimension mdmCustDim = 
                             context.getMdmPrimaryDimensionByName("CUSTOMER");
    MdmLevelHierarchy mdmChanHier = (MdmLevelHierarchy) 
                                     mdmChanDim.getDefaultHierarchy();
    MdmLevelHierarchy mdmCustHier = (MdmLevelHierarchy) 
                                     mdmCustDim.getDefaultHierarchy();
        
    StringSource chanHier = (StringSource) mdmChanHier.getSource();
    StringSource custHier = (StringSource) mdmCustHier.getSource();

    Source chanSel = chanHier.selectValue("CHANNEL_ROLLUP::CHANNEL::2");

    Source custSel = custHier.selectValue("SHIPMENTS_ROLLUP::SHIP_TO::61");

    
    // Create the query
    //Source querySource2 = prodSel.join(chanSel).join(custSel)
    //                              .join(units).join(timeSel);
      Source querySource2 = prodSel.join(chanSel).join(custSel)
                                  .join(timeSel).select(units.gt(1));
    //context.commit();
    //context.displayResult(querySource2);

    //Prepare and commit the current Transaction.
    try
    {
      tp.prepareCurrentTransaction();
    }
    catch(NotCommittableException e)
    {
      System.out.println("Caught exception " + e + ".");
    }
    tp.commitCurrentTransaction();
    
    // Create the Cursor. The DataProvider is dp.
    CursorManagerSpecification cursorMngrSpec = 
                      dp.createCursorManagerSpecification(querySource2);
    CursorManager cursorManager = dp.createCursorManager(cursorMngrSpec);
    Cursor queryCursor2 = cursorManager.createCursor();

    // Get the ValueCursor and the outputs
    CompoundCursor rootCursor = (CompoundCursor) queryCursor2;
    ValueCursor baseValueCursor = rootCursor.getValueCursor();
    List outputs = rootCursor.getOutputs();
    ValueCursor output1 = (ValueCursor) outputs.get(0);
    
    // Get the positions and values and display them.
    System.out.println("CompoundCursor Output ValueCursor" +
                       "    ValueCursor");
    System.out.println("  position      position | value  " +
                       "position | value");
    do
    {
      System.out.println("      " + rootCursor.getPosition() +
                "             " + output1.getPosition() +
                "       " + getLocalValue(output1.getCurrentString()) +
                "       " + baseValueCursor.getPosition() +
                "       " + getLocalValue(baseValueCursor.getCurrentString()));
    } while(queryCursor2.next());

    cursorManager.close();
  }

  private String getLocalValue(String uniqueValue)
  {
    int index = 0;
    if (uniqueValue.indexOf("::") > 0)
    {
      index = uniqueValue.lastIndexOf("::");
      String localValue = uniqueValue.substring((uniqueValue.lastIndexOf("::")
                                                  + 2),
                                                 uniqueValue.length());
      return(localValue);
    }
    else
      return uniqueValue;
  }
 
  public static void main(String[] args)
  {
    new CursorConceptsExamples().run(args);
  }
}
